//
//  ResumeGamesViewController.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 4/22/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "ResumeGamesViewController.h"

@interface ResumeGamesViewController () {
    NSMutableArray *gameSigns;
    RTBGame *currentGame;
}

@end

@implementation ResumeGamesViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}

- (void)viewWillAppear:(BOOL)animated {
    [self.gTableView reloadData];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
#pragma mark - tableView methods
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSLog(@"Saved Games: %lu", (unsigned long)[self.savedGames count]);
    return [self.savedGames count];
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellIdentifier = @"cell";
    
    SavedGameCell *myCell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier forIndexPath:indexPath];
    
    long row = [indexPath row];
    
    RTBGame *game = [self.savedGames objectAtIndex:row];
    
    myCell.playerName.text = [NSString stringWithFormat:@"%ld. %@", row+1, game.playerName];
    
    NSDateFormatter *df =[[NSDateFormatter alloc]init];
    [df setDateFormat:@"MM/dd/yyyy - HH:mm"];
    myCell.startDateLabel.text = [df stringFromDate:game.startDate];
    
    return myCell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    GameDetailsDAO *dao = [[GameDetailsDAO alloc]init];
    
    currentGame = [self.savedGames objectAtIndex:indexPath.row];
    
    gameSigns = [dao getCurrentTrafficSigns:currentGame.gameID];
    
//    NSLog(@"TSIGNS COUNT: %lu",(unsigned long)[gameSigns count]);
//    NSLog(@"\nCURRENT GAME: %@", game);
    
    [self performSegueWithIdentifier:@"resumeSavedGame" sender:self];
    
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        
        GameDetailsDAO *daoDetails = [[GameDetailsDAO alloc]init];
        gameSigns = [daoDetails getCurrentTrafficSigns:[[self.savedGames objectAtIndex:indexPath.row] gameID]];
        
        for (RTBSign *sign in gameSigns) {
            if (sign.userImageUrl) {
                [RTBFileHandler removeImage:sign.userImageUrl];
            }
        }
        [daoDetails deleteTrafficSigns:[[self.savedGames objectAtIndex:indexPath.row] gameID]];
        
        RTBGameDAO *dao = [[RTBGameDAO alloc]init];
        [dao deleteGame:[self.savedGames objectAtIndex:indexPath.row]];
        
        [self.savedGames removeObjectAtIndex:indexPath.row];
        [tableView reloadData];
    }
}

#pragma mark - user defined methods
//+ (void)removeImage:(NSString *)fileName
//{
//    NSFileManager *fileManager = [NSFileManager defaultManager];
//    NSString *homePath = NSHomeDirectory();
//    NSString *userSignsDirectory = [homePath stringByAppendingPathComponent:@"/Documents/userSigns"];
//    
//    NSString *filePath = [userSignsDirectory stringByAppendingPathComponent:fileName];
//    NSError *error;
//    BOOL success = [fileManager removeItemAtPath:filePath error:&error];
//    if (success) {
//        NSLog(@"UserPicture: %@ removed correctly!", fileName);
//    }
//    else
//    {
//        NSLog(@"Could not delete file '%@' -:%@ ", fileName, [error localizedDescription]);
//    }
//}


#pragma mark - Navigation

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    if([segue.identifier isEqualToString:@"resumeSavedGame"]){
        GameBoardViewController *gbvc = [segue destinationViewController];
        gbvc.currentGame = currentGame;
        gbvc.tSigns = gameSigns;
    }
}

- (IBAction)backButton:(id)sender {
    [[self navigationController] popViewControllerAnimated:YES];

}
@end
